% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.safe}
\alias{predict.safe}
\title{Make Predictions from a `safe` Object}
\usage{
\method{predict}{safe}(object, newx, s = NULL, ...)
}
\arguments{
\item{object}{Fitted `safe()` object from which predictions are to be derived.}

\item{newx}{Matrix of new predictor values for which predictions are desired.
This must be a matrix and is a required argument.}

\item{s}{Values of the penalty parameter `lambda` for which predictions are requested.
Defaults to the entire sequence used during the model fit.}

\item{...}{Not used.}
}
\value{
Returns the fitted values.
}
\description{
Produces fitted values for new predictor data using a fitted `safe()` object.
}
\details{
This function generates predictions at specified `lambda` values from a fitted `safe()` object.
It is essential to provide a new matrix of predictor values (`newx`) at which these predictions are to be made.
}
\examples{
set.seed(1)
n <- 100
p <- 5
x <- matrix(rnorm(n * p), nrow = n, ncol = p)
beta_true <- rep(0.1, 5)
gamma_true <- c(rep(1, 3), -1, -1)
mu <- x \%*\% beta_true
k <- rpois(n, lambda = exp(mu))
alpha_val <- 1
theta <- exp(x \%*\% gamma_true) / alpha_val
y <- rgamma(n, shape = alpha_val, scale = theta)
lambda_val <- 1
fit <- safe(x, y, k, 1, ind_p = c(1, 1, 1, 0, 0))
set.seed(234)
newx <- matrix(rnorm(n * p), nrow = n, ncol = p)
predict(fit, newx)

}
\seealso{
\code{\link{safe}}, \code{\link{coef.safe}}
}
