% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutoffs.searching.R
\name{find.cutoffs}
\alias{find.cutoffs}
\title{Function to calibrate the cutoff points under null hypothesis}
\usage{
find.cutoffs(
  median.c,
  K,
  L,
  lfu,
  alpha,
  power,
  accrate,
  theta,
  bio.preva,
  FAtime.phase3,
  N.iter
)
}
\arguments{
\item{median.c}{The median survival time for control group}

\item{K}{Number of biomarkers}

\item{L}{Information fraction in terms of the accumulative events in
phase II stage, e.g., K = c(1/4,1/2,1)}

\item{lfu}{Follow-up time}

\item{alpha}{One-sided familywise error rate}

\item{power}{Power}

\item{accrate}{Accrual rate}

\item{theta}{A clinically meaningful treatment effect size defined by clinicians}

\item{bio.preva}{Prevalence of biomarker(s)}

\item{FAtime.phase3}{the study ending time of phase III}

\item{N.iter}{Number of iterations}
}
\value{
find.cutoffs() returns the calibrated cutoff points that can control the
type I error rate.
}
\description{
This function is used to calibrate the cutoff points under null hypothesis
using a multi-arm multi-stage biomarker-enriched design with time-to-event
endpoints.
}
\examples{
\donttest{
find.cutoffs(median.c=12,K=2,L=c(1/4,1/2,1),lfu=0,alpha=0.05,power=0.9,
             accrate=15,theta=log(1.25),bio.preva=c(0.4,0.6),FAtime.phase3=48,
             N.iter=3)}
}
