% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_analysis.R
\name{reformat_gmt}
\alias{reformat_gmt}
\alias{read_gmt}
\alias{write_gmt}
\title{Methods to manipulate .gmt files}
\usage{
reformat_gmt(gmtfile, outputfile, replace = FALSE)

read_gmt(gmtfile)

write_gmt(gmt, outputfile, replace = FALSE)
}
\arguments{
\item{gmtfile}{path to a gene set definition file in .gmt format.}

\item{outputfile}{full path including file name to export reformatted .gmt file.}

\item{replace}{a logical value indicating whether to replace the output file if it already exists. Default to FALSE.}

\item{gmt}{a gmt object returned by \code{read_gmt}.}
}
\value{
for read_gmt, returns a list object with length equal to the total number of gene sets within the .gmt file. Each list contains three elements:
"id", "name", "genes". read_gmt & write_gmt are reimplemented based on functions from \code{ActivePathways} package.
}
\description{
Reformat, read & write .gmt file.
}
\details{
\code{reformat_gmt} replaces blank spaces within the gene-set names to help string-matching methods in downstream plot functions \code{\link{gsea_sumplot}}
,\code{\link{gsea_rwplot}}, \code{\link{gsea_heatmap}}.
}
