% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{captureci}
\alias{captureci}
\title{Capture-recapture confidence interval function}
\usage{
captureci(xmat, y, alpha)
}
\arguments{
\item{xmat}{Define 1 = in sample and 0 = not in sample. For example, if there are two samples, 
xmat has two columns; the row (1,0) represents the category of being in sample 1 but not in sample 2.}

\item{y}{Number of units corresponding to xmat.}

\item{alpha}{Confidence level with a default value of 0.05.}
}
\value{
cell: estimated cell value for the missing count of category (0, 0)

N: the estimated total counts

CI_cell: the estimated confidence interval for the missing category count

CI_N: the estimated confidence interval for total counts
}
\description{
Compute a confidence interval for a capture-recapture sample using the method of Cormack (1992).
}
\examples{
xmat <- cbind(c(1,1,0),c(1,0,1))
y <- c(20,180,80)
captureci(xmat, y, alpha = 0.1)
}
