% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refit.R
\name{refit}
\alias{refit}
\title{Refit SLOPE Model with Optimal Parameters}
\usage{
refit(object, x, y, measure = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{'TrainedSLOPE'}, typically from a call to
\code{\link[=cvSLOPE]{cvSLOPE()}} or \code{\link[=trainSLOPE]{trainSLOPE()}}}

\item{x}{the design matrix}

\item{y}{the response vector}

\item{measure}{which performance measure to use for selecting optimal
parameters. If \code{NULL} (default), uses the first measure in the
\code{TrainedSLOPE} object.}

\item{...}{additional arguments passed to \code{\link[=SLOPE]{SLOPE()}}}
}
\value{
An object of class \code{'SLOPE'} fit with the optimal parameters
}
\description{
Refits a SLOPE model using the optimal parameters found through
cross-validation. This is a convenience function to avoid having to manually
extract optimal parameters and refit.
}
\examples{
# Cross-validation
tune <- trainSLOPE(
  bodyfat$x,
  bodyfat$y,
  q = c(0.1, 0.2),
  measure = "mse"
)

# Refit with optimal parameters
fit <- refit(tune, bodyfat$x, bodyfat$y)

# Use the fitted model
coef(fit)
predict(fit, bodyfat$x)

}
\seealso{
\code{\link[=SLOPE]{SLOPE()}}

Other model-tuning: 
\code{\link{cvSLOPE}()},
\code{\link{plot.TrainedSLOPE}()},
\code{\link{summary.TrainedSLOPE}()},
\code{\link{trainSLOPE}()}
}
\concept{model-tuning}
