% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.per.segment.R
\name{dist.per.segment}
\alias{dist.per.segment}
\title{Calculate distances of stream segments}
\usage{
dist.per.segment(
  network,
  nodes,
  lon.name = "lon",
  lat.name = "lat",
  node.name = "id"
)
}
\arguments{
\item{network}{(data.frame) A data frame with the the following columns (in this order): "lon", "lat", "id" (the output of \code{\link{increase.stream.points}})}

\item{nodes}{(data.frame) A data frame of coordinates for the nodes where stream segments meet. Coordinates should be in the same projected system as the input to \code{\link{increase.stream.points}}. Should contain columns for latitude, longitude, and identity of each node (\strong{identities must be integers and go from 1 to number of nodes}, but they do not need to correspond with anything in the input to \code{\link{increase.stream.points}})}

\item{lon.name}{(character) Name of the column of longitudes (in quotes). Default = "lon"}

\item{lat.name}{(character) Name of the column of latitudes (in quotes). Default = "lat"}

\item{node.name}{(character) Name of the column of segment identities (in quotes). Default = "id"}
}
\value{
A list containing two objects:

\code{segments} = the first object: a data frame with the id of each segment, nodes at either end of the segment, and the total distance (in meters) of that segment.

\code{all.distances} = the second object: a list, with one data frame per segment containing the distances between each consecutive pair of points along the line.
}
\description{
For each segment of a stream, it calculates the distance between each pair of consecutive points and the total distance of that segment (in meters)
}
\keyword{internal}
