% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat.trj.R
\name{cat.trj}
\alias{cat.trj}
\title{Concatenate simulations}
\usage{
cat.trj(trj1, ...)
}
\arguments{
\item{trj1}{the first trj file}

\item{...}{additional trj files}
}
\value{
A trj object with the simulations concatenated
}
\description{
Function to concatenate two simulations.
}
\examples{
# Read the simulations
trj1 <- read.trj(trjfile = system.file("extdata", "HIF2a-MD.xtc", package = "SOMMD"),
  topfile = system.file("extdata", "HIF2a.gro", package = "SOMMD"))
trj2 <- read.trj(trjfile = system.file("extdata", "HIF2a-MD-2.xtc", package = "SOMMD"),
  topfile = system.file("extdata", "HIF2a.gro", package = "SOMMD"))
# Concatenate the simulations
  trj <- cat.trj(trj1, trj2)

}
\author{
Stefano Motta \email{stefano.motta@unimib.it}
}
