% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPARRAfairness_functions.R
\name{adjusted_fdr}
\alias{adjusted_fdr}
\title{adjusted_fdr}
\usage{
adjusted_fdr(
  scores,
  target,
  category,
  group1,
  group2,
  cutoffs = seq(min(scores, na.rm = TRUE), max(scores, na.rm = TRUE), length = 100),
  nboot = 100
)
}
\arguments{
\item{scores}{vector of risk scores}

\item{target}{vector of values of target (which risk score aims to predict)}

\item{category}{vector of categories}

\item{group1}{indices of group 1}

\item{group2}{indices of group 2}

\item{cutoffs}{score cutoffs at which to estimate metric (default 100 evenly-spaced)}

\item{nboot}{number of bootstrap samples for standard error}
}
\value{
matrix of dimension length(cutoffs)x4, with (i,2g-1)th entry the relevant fairness metric for group g at the ith cutoff value and (i,2g)th entry the approximate standard error of the (i,2g-1)th entry
}
\description{
Estimates false discovery rate P(target=FALSE|score>cutoff,group=g) 'adjusted' for some category.
}
\details{
Namely, calculates

sum ( P(target=FALSE|score>cutoff,category=c,group=g)P(category=c|score<cutoff) )

where the sum is over categories c.
}
\examples{
# See vignette
}
