\name{SSAfcast}
\alias{SSAfcast}

\title{
Singular Spectrum Analysis Based Time Series Forecasting Model
}
\description{
One of the main advantages of SSA is that it can generate forecasts for either the individual components of a time series or the reconstructed series after it has been decomposed (Ghodsi et al., 2018). SSA-Linear Recurrent Formulae (SSA-LRF) model has been employed successfully in hydrological forecasting and other practical applications (Zhang et al., 2011).
}

\usage{SSAfcast(data, L=12, corr_thr=0.97,horizon=12)
}

\arguments{
  \item{data}{
Univariate time series data
}
  \item{L}{
Integer, window length, multiple of periodicity of data series
}
  \item{corr_thr}{
 Correlation between the component pairs (0.97 default)
}
  \item{horizon}{
Step ahead forecasting
}
}

\details{
SSA decomposes a time series into interpretable components like trends, oscillations, and noise without strict distributional and structural assumptions (Golyandina and Zhigljavsky, 2013). SSA offers various applications, including trend identification, smoothing, seasonality extraction, and forecasting (Hassani et al., 2007). SSA Linear Recurrent Formulae model has been employed successfully in hydrological forecasting and other practical applications (Zhang et al., 2011). Finally, the prediction results of all the three components are aggregated to formulate an ensemble output for the input time series.
}

\value{
 \item{Final_forecast}{Final forecasted value of the SSA based forecasting model. It is obtained by combining the forecasted value of all individual reconstruction series}
  \item{Data_test}{Test data of univariate time series}
  \item{RMSE_SSA}{Root Mean Square Error (RMSE) for SSA based forecasting model}
  \item{MAPE_SSA }{Mean Absolute Percentage Error (MAPE) for SSA based forecasting model}
  \item{MAE_SSA}{Mean Absolute Error (MAE) for SSA based forecasting model}
}

\references{
Hassani, H (2007). Singular Spectrum Analysis: Methodology and Comparison.  Journal of  Data Science, 5(2), 239-257.
}

\examples{
set.seed(123)
ts_data <- rnorm(100)
result <- SSAfcast(ts_data, L = 12, corr_thr = 0.95, horizon = 10)
result
}

