% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssim_constant.R
\name{ssim_constant}
\alias{ssim_constant}
\title{Constants for the SSIM Index for polygon maps.}
\usage{
ssim_constant(shape, map1, map2, standardize = TRUE)
}
\arguments{
\item{shape}{a \code{sf} polygon containing the attributes that can create polygon-based maps.}

\item{map1}{The name of the first map to compare as a column in the shape.}

\item{map2}{The name of the second map to compare as a column in the shape.}

\item{standardize}{If TRUE, standardize the variables before computing the SSIM. Default is TRUE.}
}
\value{
The rescaled constants (k1 and k2).
}
\description{
This function calculates rescaled constants (k1 and k2) for the SSIM index based on the global maximum value of the maps.
}
\details{
This function calculates the rescaled constants (k1 and k2) for the SSIM index.
k1 and k2 in the original SSIM method, which are for the 8-bit grey scale images, are 0.01 and 0.03 respectively.
The SSIM for maps can use the rescaled k1 and k2 based on the global maximum value of two maps.
}
\examples{
# Load example sf class Toronto Area with attributes for maps:
# Toronto Areas with attributes for maps:Pampalon Index,CIMD Index,
# and percentage of household commuting within the same Census Sub-Division of residence.
data("Toronto")
ssim_constant(Toronto,"PP_SDD","CIMD_SDD")

}
