% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_SSM.R
\name{degl}
\alias{degl}
\title{Construct matrix of exponent vectors.}
\usage{
degl(d, N, exclude = list())
}
\arguments{
\item{d}{A number. This determines the number of columns in the
output matrix}

\item{N}{A number. This determines the number of rows in the output matrix.}

\item{exclude}{(optional) A list of integer vectors.  If this argument is
provided, the generated matrix will not contain any rows which are only
non-zero in the columns specified by any of the vectors in the list.}
}
\description{
This function is called by \code{\link{fit.ssm}} when it needs to construct
the matrix of exponent vectors stored in the \code{basis} slot.
}
\details{
The algorithm works by repeated calls to \code{\link{comb}} to generate all
possible exponent vectors of a given degree until \code{N} vectors have been
generated.  Any generated vector is checked to make sure that it's non-zero
entries do not match a vector provided in \code{exclude} before being added
to the output matrix.
}
\keyword{internal}

