% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_MI.R
\name{plot.ssvs_mi}
\alias{plot.ssvs_mi}
\title{Plot SSVS-MI Estimates and Marginal Inclusion Probabilities (MIP)}
\usage{
\method{plot}{ssvs_mi}(
  x,
  type = "both",
  threshold = 0.5,
  legend = TRUE,
  est_title = NULL,
  mip_title = NULL,
  color = TRUE,
  ...
)
}
\arguments{
\item{x}{An ssvs result object obtained from \code{\link[=ssvs_mi]{ssvs_mi()}}}

\item{type}{Defaults to "both", can change to "estimate" or "MIP".}

\item{threshold}{A numeric value (between 0 and 1) specifying the MIP threshold to highlight significant predictors.
Defaults to 0.5.}

\item{legend}{Logical indicating whether to include a legend for the threshold. Defaults to \code{TRUE}.}

\item{est_title}{A character string specifying the plot title. Defaults to \code{"SSVS-MI estimates"}.}

\item{mip_title}{A character string specifying the plot title. Defaults to \code{"Multiple Inclusion Probability for SSVS-MI"}.}

\item{color}{Logical indicating whether to use color to highlight thresholds. Defaults to \code{TRUE}.}

\item{...}{Ignored}
}
\value{
Two \code{ggplot2} objects representing the plot of SSVS estimates and the plot of MIP with thresholds.
}
\description{
This function creates a plot of SSVS-MI estimates with minimum and maximum and a plot for marginal
inclusion probabilities (MIP) optional thresholds for highlighting significant predictors..
}
\examples{
\donttest{
data(imputed_mtcars)
outcome <- 'qsec'
predictors <- c('cyl', 'disp', 'hp', 'drat', 'wt', 'vs', 'am', 'gear', 'carb','mpg')
imputation <- '.imp'
results <- ssvs_mi(data = imputed_mtcars, y = outcome, x = predictors, imp = imputation)
plot(results)
}
}
