#' Supported copula types
#'
#' A list containing supported copula types.
#'
#' @format A list of copula types.
#' \describe{
#'   \item{copulas}{"Gaussian" "Clayton" "Frank" "Gumbel" "Joe"}
#' }
"copula_list"

#' Data of the article "Probabilistic Crop Yields Forecasts With Spatio-Temporal Conditional Copula Using Extreme Weather Covariates"
#'
#' Contains crop yields and climate indices data of 24 CD regions in Ontario from 1950 to 2022
#'
#' @format A data frame with 1752 rows and 38 variables:
#' \describe{
#'      \item{time}{chr: year from 1950-2022}
#'      \item{CAR_CODE}{num: 1-4}
#'      \item{CAR}{chr: Southern, Western, Central, Eastern Ontario}
#'      \item{CD_CODE}{num}
#'      \item{CD}{chr: 24 subregions}
#'      \item{ID}{chr}
#'      \item{lat}{num: latitude}
#'      \item{lon}{num: longitude}
#'      \item{yield}{num: wheat crop yield per census division, in bushel/acre}
#'      \item{cdd}{num: Annual maximum number of consecutive days with daily precipitation below 1mm (unit = days)}
#'      \item{cddcold_18}{num: Annual cooling degree days above 18C (unit = degree_days)}
#'      \item{dlyfrzthw_tx0_tn}{num: Annual number of days with a diurnal freeze-thaw cycle : tmax > 0 degc and tmin <= -1 degc}
#'      \item{first_fall_frost}{num: First day of year with temperature below 0 degc for at least 1 days}
#'      \item{frost_days}{num: Annual number of days with minimum daily temperature below 0C}
#'      \item{ice_days}{num: Annual number of days with maximum daily temperature below 0 degC}
#'      \item{nr_cdd}{num: The annual number of dry periods of 6 days and more, during which the maximal precipitation on a window of 6 days is under 1.0 mm}
#'      \item{prcptot}{num: Annual total precipitation (unit = mm)}
#'      \item{r1mm}{num: Annual number of days with daily precipitation over 1.0 mm/day}
#'      \item{r10mm}{num: Annual number of days with daily precipitation over 10.0 mm/day}
#'      \item{r20mm}{num: Annual number of days with daily precipitation over 20.0 mm/day}
#'      \item{rx1day}{num: Annual maximum 1-day total precipitation (unit = mm)}
#'      \item{rx5day}{num: Annual maximum 5-day total precipitation (unit = mm)}
#'      \item{tg_mean}{num: Annual mean of daily mean temperatures  (unit = C degrees)}
#'      \item{tn_mean}{num: Annual mean of daily minimum temperatures (unit = C degrees)}
#'      \item{tn_min}{num: Annual minimum of daily minimum temperatures (unit = C degrees)}
#'      \item{tnlt_-15}{num: Annual number of days where daily minimum temperature is below -15 degC}
#'      \item{tnlt_-25}{num: Annual number of days where daily minimum temperature is below -25 degC}
#'      \item{tr_18}{num: Annual number of tropical nights : defined as days with minimum daily temperature above 18 degc}
#'      \item{tr_20}{num: Annual number of tropical nights : defined as days with minimum daily temperature above 20 degc}
#'      \item{tr_22}{num: Annual number of tropical nights : defined as days with minimum daily temperature above 22 degc}
#'      \item{tx_max}{num: Annual minimum of daily maximum temperature (unit = C degrees)}
#'      \item{tx_mean}{num: Annual mean of daily maximum temperature (unit = C degrees)}
#'      \item{txgt_25}{num: Annual number of days where daily maximum temperature exceeds 25 degC}
#'      \item{txgt_27}{num: Annual number of days where daily maximum temperature exceeds 27 degC}
#'      \item{txgt_29}{num: Annual number of days where daily maximum temperature exceeds 29 degC}
#'      \item{txgt_30}{num: Annual number of days where daily maximum temperature exceeds 30 degC}
#'      \item{txgt_32}{num: Annual number of days where daily maximum temperature exceeds 32 degC}
#'      }
#'
#' @source ClimateData.ca
#'
"cropyields_covariates"

#' Initial Parameters for 2D Pseudo-Loglikelihood-Generalized Estimation
#'
#' @format A numeric vector of length \eqn{(2+M+4*D*M)}, structured as follows:
#' \describe{
#'   \item{omega}{Baseline autoregressive coefficient.}
#'   \item{alpha}{Parameter controlling variance.}
#'   \item{gamma1, gamma2, gamma3}{Coefficients related to external factors.}
#'   \item{Climate variable parameters}{For each climate variable in each region, the following parameters are included:}
#'   \itemize{
#'     \item \code{mean(z)}, \code{sd(z)}, \code{sd(z)}, \code{xi_gev} for each region and variable.
#'   }
#' }
#'
"init_params_full_G"

#' Initial Parameters for 2D Pseudo-Loglikelihood Estimation
#'
#' @format A numeric vector of length \eqn{(2+M+4*D*M)} where:
#' \describe{
#'   \item{omega}{Baseline autoregressive coefficient.}
#'   \item{alpha}{Parameter controlling variance.}
#'   \item{gamma1, gamma2, gamma3}{Coefficients related to external factors.}
#'   \item{phi_gev}{AR(1) coefficient for GEV.}
#'   \item{sigma_mu}{Std dev of innovations for AR(1) process for GEV.}
#'   \item{sigma_gev}{GEV scale parameter for GEV.}
#'   \item{xi_gev}{GEV shape parameter for GEV.}
#' }
#'
"init_params_full"

#' Initial Parameters for 2D Pseudo-Loglikelihood Estimation without GEV models for covariates
#'
#' @format A numeric vector of length \eqn{(2+M)} where:
#' \describe{
#'   \item{omega}{Baseline autoregressive coefficient.}
#'   \item{alpha}{Parameter controlling variance.}
#'   \item{gamma1, gamma2, gamma3}{Coefficients related to external factors.}
#' }
#'
"init_params_noGEV"

#' list containing Dufferin and Wellington
#'
"medoid_names"

#' 54
#'
"n_train"

#' 19
#'
"n_test"

#' 1950-2003
#'
"time_train"

#' 2004-2022
#'
"time_test"

#' 1950-2022
#'
"time_all"

#' Standardized Covariates Array for Crop Yield Forecasting
#'
#' @format A three-dimensional array with dimensions \eqn{(n_train, D, M)}:
#' \describe{
#'   \item{n_test}{Number of time points used in the training set.}
#'   \item{D}{Number of regions analyzed (\code{Dufferin}, \code{Wellington}).}
#'   \item{M}{Number of selected climate covariates used for modeling (\code{cdd},\code{frost_days},\code{rx1day}, \code{tg_mean}, \code{txgt_25}).}
#' }
#'
#'
#' @source Derived from historical climate data from ClimateData.ca.
#'
"zz_train"

#' Standardized Covariates Array for Crop Yield Forecasting
#'
#' @format A three-dimensional array with dimensions \eqn{(n_test, D, M)}:
#' \describe{
#'   \item{n_test}{Number of time points used in the testing set.}
#'   \item{D}{Number of regions analyzed (\code{Dufferin}, \code{Wellington}).}
#'   \item{M}{Number of selected climate covariates used for modeling (\code{cdd},\code{frost_days},\code{rx1day}, \code{tg_mean}, \code{txgt_25}).}
#' }
#'
#'
#' @source Derived from historical climate data.
#'
"zz_test"

#' Standardized Covariates Array for Crop Yield Forecasting
#'
#' @format A three-dimensional array with dimensions \eqn{(n_train+n_test, D, M)}:
#' \describe{
#'   \item{n_train+n_test}{Number of time points used in the training set.}
#'   \item{D}{Number of regions analyzed (\code{Dufferin}, \code{Wellington}).}
#'   \item{M}{Number of selected climate covariates used for modeling (\code{cdd},\code{frost_days},\code{rx1day}, \code{tg_mean}, \code{txgt_25}).}
#' }
#'
#'
#' @source Derived from historical climate data.
#'
"zz_all"

#' Pseudo-Observations of BSTS Residuals for Crop Yield Forecasting
#'
#' @format A matrix with dimensions \eqn{(n_train, D)}:
#' \describe{
#'   \item{n_train}{Number of time points used in the training set.}
#'   \item{D}{Number of regions analyzed (\code{Dufferin}, \code{Wellington}).}
#' }
#'
#' @source Derived from residuals of BSTS models fitted to crop yield data.
#'
"uu"

#' Maximized Covariates Matrix for Crop Yield Forecasting
#'
#' @format A three-dimensional array with dimensions \eqn{(n_train, M)}:
#' \describe{
#'   \item{n_test}{Number of time points used in the training set.}
#'   \item{M}{Number of selected climate covariates used for modeling (\code{cdd},\code{frost_days},\code{rx1day}, \code{tg_mean}, \code{txgt_25}).}
#' }
#' @source Derived from historical climate data from ClimateData.ca.
#'
"xx_train"

#' Maximized Covariates Matrix for Crop Yield Forecasting
#'
#' @format A three-dimensional array with dimensions \eqn{(n_test, M)}:
#' \describe{
#'   \item{n_test}{Number of time points used in the testing set.}
#'   \item{M}{Number of selected climate covariates used for modeling (\code{cdd},\code{frost_days},\code{rx1day}, \code{tg_mean}, \code{txgt_25}).}
#' }
#'
#' @source Derived from historical climate data from ClimateData.ca.
#'
"xx_test"

#' Maximized Covariates Matrix for Crop Yield Forecasting
#'
#' @format A three-dimensional array with dimensions \eqn{(n_train+n_test, M)}:
#' \describe{
#'   \item{n_train+n_test}{Number of time points used in the training set.}
#'   \item{M}{Number of selected climate covariates used for modeling (\code{cdd},\code{frost_days},\code{rx1day}, \code{tg_mean}, \code{txgt_25}).}
#' }
#'
#' @source Derived from historical climate data from ClimateData.ca.
#'
"xx_all"

#' Crop Yield Data for Testing in BSTS Models
#'
#' @format A matrix with dimensions \eqn{(n_train, D)}:
#' \describe{
#'   \item{n_train}{Number of time points used in the test set.}
#'   \item{D}{Number of regions analyzed (\code{Dufferin}, \code{Wellington}).}
#' }
#'
#' @source Historical crop yield records from ClimateData.ca.
#'
"yy_test"

#' Crop Yield Data for Training in BSTS Models
#'
#' @format A matrix with dimensions \eqn{(n_test, D)}:
#' \describe{
#'   \item{n_test}{Number of time points used in the train set.}
#'   \item{D}{Number of regions analyzed (\code{Dufferin}, \code{Wellington}).}
#' }
#'
#' @source Historical crop yield records from ClimateData.ca.
#'
"yy_train"

#' Crop Yield Data
#'
#' @format A matrix with dimensions \eqn{(n_train+n_test, D)}:
#' \describe{
#'   \item{n_train+n_test}{Number of time points used in the test set.}
#'   \item{D}{Number of regions analyzed (\code{Dufferin}, \code{Wellington}).}
#' }
#'
#' @source Historical crop yield records from ClimateData.ca.
#'
"yy_all"
