% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_weights.R
\name{plot_weights}
\alias{plot_weights}
\title{Plotting the scenario weights of a Stressed Model}
\usage{
plot_weights(
  object,
  xCol = 1,
  wCol = "all",
  n,
  x_limits,
  y_limits,
  displ = TRUE
)
}
\arguments{
\item{object}{A \code{SWIM} or \code{SWIMw} object.}

\item{xCol}{Numeric or character, (name of) the column of the underlying data
of the \code{object} (\code{default = 1}).}

\item{wCol}{Vector, the columns of the scenario weights 
of the \code{object} corresponding to different 
stresses (\code{default = "all"}).}

\item{n}{Integer, the number of points used to plot 
(\code{default = 5000} or the minimum of the data). If 
\code{n = "all"}, all data points are plotted. If \code{n} is
a subset of points, the plotted scenario weights are chosen in 
an equidistant way.}

\item{x_limits}{Vector, the limits of the x-axis of the plot, the
value for \code{xlim} in the \code{coord_cartesian}
function in \code{ggplot}.}

\item{y_limits}{Vector, the limits of the y-axis of the plot, the
value for \code{ylim} in the \code{coord_cartesian}
function in \code{ggplot}.}

\item{displ}{Logical, if \code{TRUE} the plot is displayed,
otherwise the data.frame for customised plotting with
\code{ggplot} is returned (\code{default = TRUE}).}
}
\value{
If \code{displ = TRUE}, a plot displaying the scenario
    weights of a stochastic model against a model component.

    If \code{displ = FALSE}, a data.frame for customised plotting with
    \code{ggplot}. The data.frame contains the following columns:
    \code{grid}, the grid points to plot the quantiles,
    \code{stress} (the stresses) and \code{value} (the quantile values). \cr
    Denote by \code{res} the return of the function call, then
    \code{ggplot} can be called via:
    \deqn{ggplot(res, aes(x = res[ ,1], y = value))}
    \deqn{ + geom_lines(aes(color = factor(stress))).}
}
\description{
Plots the scenario weights of a stressed model against a model component.
}
\examples{
 \donttest{
## example with a stress with \code{credit_data} data set:
data("credit_data")
## two stresses in VaR
model_stress <- stress_VaR(credit_data, alpha = c(0.9, 0.95), q_ratio = 1.1, k =1) 
plot_weights(model_stress, xCol = "L", wCol = 1:2)

## additional stress on VaR and ES
model_stress <- stress_VaR_ES(model_stress, alpha = 0.9, q_ratio = 1.1, s_ratio = 1.2, k =1) 
plot_weights(model_stress, xCol = "L", wCol = "all", n = 1000, x_limits = c(0, 3500), 
             y_limits = c(0, 10))
             }

}
\seealso{
See \code{\link{plot_quantile}} for plotting sample quantiles of a 
    stressed model and \code{\link{plot_cdf}} for plotting empirical 
    distribution functions.
}
