% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HydstraSiteDetails.R
\name{HydstraSiteDetails}
\alias{HydstraSiteDetails}
\title{Get streamflow station information from Hydstra API}
\usage{
HydstraSiteDetails(site, state, out_folder, flood_level = NA)
}
\arguments{
\item{site}{station number, e.g. "425018"}

\item{state}{relevant state database foro the station, e.g. "NSW"}

\item{out_folder}{path to folder to save outputs}

\item{flood_level}{optional, water level in stage datum to plot on the cross section data}
}
\value{
a vector of length 3, with the number of cross sections, rating curves and streamflow gaugings found, respectively.
}
\description{
This function use the API associated with states' Hydstra databases to return useful site information.
}
\details{
Currently, the relevant websites are useful for site discovery:
\itemize{
\item https://water-monitoring.information.qld.gov.au
\item https://realtimedata.waternsw.com.au
\item https://data.water.vic.gov.au/WMIS
}

The Bureau of Meteorology's \href{http://www.bom.gov.au/waterdata/}{Water Data Online} site is also useful, which can also be queried using \code{get_station_list()} from \href{https://github.com/buzacott/bomWater/}{BomWater package}.

The function will save a number of files to \code{out_folder} that have a file name starting with the station number followed by:
\itemize{
\item site_info.csv: general site information returned, e.g. site name, coordinates, length of record, elevation
\item x_sec.csv: chainage \code{chain} and elevation (\code{rl} in gauge datum) of the control section
\item rating.csv: current rating curve, the discharge (\code{vf} in ML/d) for a gauge height \code{vf}, and also as above the cease to flow level (\code{above_ctf})
\item gaugings.csv: record of streamflow gaugings available
\item discharge.csv: daily time series of streamflow, over a 9am - 9am period
\item plot.png: summary plot of the above data
}

Quality codes shown on the plot are those used by the Bureau of Meteorology \href{http://www.bom.gov.au/water/hrs/qc_doc.shtml}{defined here}
}
\examples{
\dontrun{
HydstraSiteDetails("425018","NSW","c:/Temp")
}
}
