% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardised_rates_df.R
\name{standardised_rates_df}
\alias{standardised_rates_df}
\title{Standardised Prevalence Rates.}
\usage{
standardised_rates_df(
  df,
  Split_by,
  Condition,
  Population_Standard,
  Granular = FALSE,
  ...
)
}
\arguments{
\item{df}{a tidy data frame in standard Master Patient Index format ie SangerTools::PopHealthData.}

\item{Split_by}{A column name within df for which the standardised rates will be calculated for.}

\item{Condition}{A Health condition flag denoted by 1 & 0; where 1 denotes the patient being positive for the health condition.}

\item{Population_Standard}{Population Standard Weight used for Standardising; default set to NULL; which denotes  use of Age Structure of df.}

\item{Granular}{Takes a boolean value. If set to TRUE will output a tibble with Standardised Rates using values provided in `Split_col` and `...`By default is set to FALSE.}

\item{...}{Variables used to standardise by; Must always have Age band for age standardisation, additional variables are optional and should be passed separated by commas.}
}
\value{
A tibble containing standardised Prevalence Rates by specified group.
}
\description{
Standardisation will be  performed
for all unique values in the column passed to `split_by`. If input data frame does not contain age bands
or age bands are not of class factor, it is recommended to use \code{\link{age_bandizer}} or \code{\link{age_bandizer_2}}.
After the function has run, the output can be copied using \code{\link{excel_clip}}  or  written to a database using \code{\link{df_to_sql}}.
Alternatively, if you are interested in seeing the effects of age confounding; consider joining the outputs of this function with the output from \code{\link{crude_rates}}
using a \code{\link[dplyr]{left_join}}
}
\examples{
library(SangerTools)
health_data <- SangerTools::age_bandizer(df = SangerTools::master_patient_index,
                                         Age_col=Age)
df_rates <- standardised_rates_df(
  df = health_data,
  Split_by = Locality,
  Condition = Diabetes,
  Population_Standard = NULL,
  Granular = TRUE,
  Ageband
)
print(df_rates)
}
