% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCSSW.R
\name{seasonder_CSSW2CSData}
\alias{seasonder_CSSW2CSData}
\title{Transform CSSW Body to SeaSonde CS Data Structure}
\usage{
seasonder_CSSW2CSData(body)
}
\arguments{
\item{body}{A list representing the body of a CSSW file. Each element of the list is expected to be a
cell containing the following fields: \code{indx} (which includes an \code{index}), \code{cs1a}, \code{cs2a}, \code{cs3a},
\code{c12m}, \code{c12a}, \code{c13m}, \code{c13a}, \code{c23m}, \code{c23a} and \code{csqf}.}
}
\value{
A list with the following components:
\describe{
\item{SSA1}{A numeric matrix containing self-spectra from \code{cs1a}.}
\item{SSA2}{A numeric matrix containing self-spectra from \code{cs2a}.}
\item{SSA3}{A numeric matrix containing self-spectra from \code{cs3a}.}
\item{CS12}{A complex matrix formed by pairing \code{c12m} (real) and \code{c12a} (imaginary).}
\item{CS13}{A complex matrix formed by pairing \code{c13m} (real) and \code{c13a} (imaginary).}
\item{CS23}{A complex matrix formed by pairing \code{c23m} (real) and \code{c23a} (imaginary).}
\item{QC}{A numeric matrix containing the quality control data from \code{csqf}.}
}
}
\description{
This function converts the body structure of a CSSW file into a list of matrices that conform
to the data structure required for creating a SeaSondeRCS object. The conversion is performed
by mapping specific fields:
\describe{
\item{SSA1, SSA2, SSA3}{Matrices are built using the numeric vectors found in the \code{cs1a}, \code{cs2a}
and \code{cs3a} fields respectively.}
\item{CS12, CS13, CS23}{Each complex cross-spectra matrix is formed by combining the real parts
from \code{c12m}, \code{c13m} and \code{c23m} with the corresponding imaginary parts
from \code{c12a}, \code{c13a} and \code{c23a}.}
\item{QC}{The quality control matrix is obtained directly from the \code{csqf} field.}
}
}
\details{
Each row in the output matrices corresponds to the index provided by \code{cell$indx$index} in the input list.

The function first determines the maximum index among the cells in the body, which defines the number of rows
for the matrices. Then, it calculates the number of columns for each matrix based on the length of the corresponding
vectors from the first cell where they appear. Finally, each cell's data is inserted into the appropriate row
of the matrices as indicated by the cell's \code{indx$index} value.
}
\examples{
  # Example with a single cell
  cell <- list(
    indx  = list(index = 1),
    cs1a  = c(1, 2, 3),
    cs2a  = c(4, 5, 6),
    cs3a  = c(7, 8, 9),
    c12m  = c(10, 11, 12),
    c12a  = c(13, 14, 15),
    c13m  = c(16, 17, 18),
    c13a  = c(19, 20, 21),
    c23m  = c(22, 23, 24),
    c23a  = c(25, 26, 27),
    csqf  = c(28, 29, 30)
  )
  body <- list(cell)
  transformed <- seasonder_CSSW2CSData(body)
  print(transformed)

}
