% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRAPM.R
\name{seasonder_extrapolateAPM}
\alias{seasonder_extrapolateAPM}
\title{Extrapolate SeaSondeR APM Matrix}
\usage{
seasonder_extrapolateAPM(seasonder_apm_object, n = 1)
}
\arguments{
\item{seasonder_apm_object}{A matrix containing SeaSondeR APM measurements. Its attributes
include "BEAR" (numeric vector of bearings) and "BearingResolution" (numeric resolution).}

\item{n}{An integer specifying how many extrapolated columns to add on each side (default is 1).}
}
\value{
A modified matrix with \code{n} extrapolated columns added to both sides. The column names
and the "BEAR" attribute are updated with the new bearings, while the "BearingResolution"
attribute remains unchanged.
}
\description{
This function performs linear extrapolation on the SeaSondeR APM measurement matrix.
It adds \code{n} extrapolated columns to both the left and right sides of the matrix.
}
\details{
The function retrieves the original bearing vector from the APM object using
\code{seasonder_getSeaSondeRAPM_BEAR} and obtains the bearing resolution (attribute
"BearingResolution"). If \code{n == 0}, the original matrix is returned unchanged.
For \code{n > 0}, new bearings are generated for both sides using the resolution. The
left side is extrapolated using the slope computed from the first two columns of the matrix,
and the right side is extrapolated using the slope from the last two columns. The new columns
are then combined with the original matrix, and the column names and the "BEAR" attribute
are updated to reflect the complete set of bearings.
}
\examples{
# Extrapolate loops for a test SeaSondeRAPM object
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
obj <- seasonder_readSeaSondeRAPMFile(apm_file)
result <- seasonder_extrapolateAPM(obj, n = 1)
}
