% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getCSHeaderByPath}
\alias{seasonder_getCSHeaderByPath}
\title{Retrieve a value from the SeaSondeRCS header by a specific path}
\usage{
seasonder_getCSHeaderByPath(seasonder_obj, path, warn_missing = TRUE)
}
\arguments{
\item{seasonder_obj}{A SeaSondeRCS object.}

\item{path}{A character vector specifying the field or nested fields to retrieve.}

\item{warn_missing}{Logical; if \code{TRUE}, a warning is issued if the specified path is not found in the header.}
}
\value{
The value at the specified path in the header. If the path is not found, NULL is returned and a warning is thrown.
}
\description{
This function retrieves a specific value from the SeaSondeRCS object's header based on the provided path.
The path can be a single field name or a list of nested field names.
}
\section{Condition Management}{

This function utilizes the \code{rlang} package to manage errors and conditions, and provide detailed and structured condition messages:

\strong{Condition Classes}:
\itemize{
\item \code{seasonder_SeaSonderCS_field_not_found_in_header}: Indicates that the specified path was not found in the header.
}

\strong{Condition Cases}:
\itemize{
\item Field or nested fields specified by the path are not found in the header.
}
}

\examples{
# Minimal example for seasonder_getCSHeaderByPath
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
field_value <- seasonder_getCSHeaderByPath(cs_obj, c("nRangeCells"))
print(field_value)
}
