% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCSSY.R
\name{seasonder_readSeaSondeRCSSYFile}
\alias{seasonder_readSeaSondeRCSSYFile}
\title{Read SeaSonde RCSSY File and Create SeaSondeRCS Object}
\usage{
seasonder_readSeaSondeRCSSYFile(
  filepath,
  specs_path = seasonder_defaultSpecsFilePath("CSSY"),
  endian = "big"
)
}
\arguments{
\item{filepath}{A character string specifying the path to the SeaSonde RCSSY file.}

\item{specs_path}{A character string specifying the path to the YAML file containing CSSY specifications.
Defaults to the output of \code{seasonder_defaultSpecsFilePath("CSSY")}.}

\item{endian}{A character string indicating the byte order used in the file. Defaults to \code{"big"}.}
}
\value{
A SeaSondeRCS object containing the parsed header and data.
}
\description{
This function reads a SeaSonde RCSSY file from a specified file path and parses its content
into a SeaSondeRCS object. The file is processed by reading its header and body sections using
CSSY specifications provided via a YAML file.
}
\details{
The function executes the following steps:
\enumerate{
\item Sets up error handling parameters specific to the function.
\item Retrieves YAML specifications for the key size block from the CSSY spec file.
\item Attempts to open the file in binary mode ("rb") with warnings suppressed.
\item Reads the file key and uses it to extract file specs.
\item Reads the header key, retrieves header specs, and parses the CSSY header.
\item Converts the CSSY header into a valid SeaSondeRCS header.
\item Reads the body key, retrieves body specs, and parses the CSSY body.
\item Transforms the CSSY body into a SeaSondeRCS data structure.
\item Combines the header and data into a SeaSondeRCS object.
}
}
