% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonder_log.R
\name{seasonder_splitLog}
\alias{seasonder_splitLog}
\title{Split Logs Based on Time Thresholds}
\usage{
seasonder_splitLog(
  threshold = NULL,
  threshold_factor = 4,
  threshold_quantile = 0.9,
  min_threshold_secs = 10
)
}
\arguments{
\item{threshold}{The time difference threshold for splitting the logs. If NULL, it's calculated.}

\item{threshold_factor}{Multiplicative factor applied to the calculated threshold.}

\item{threshold_quantile}{Quantile used for threshold calculation if \code{threshold} is NULL.}

\item{min_threshold_secs}{Minimum threshold in seconds.}
}
\value{
A list of log blocks, each block being a vector of log entries.
}
\description{
The function splits the log entries into blocks based on time gaps between timestamps. The threshold
for splitting can be provided or calculated based on the gaps in the log timestamps.
}
\examples{
# Enable logging
seasonder_enableLogs()
# Log some messages
seasonder_log("First log entry", "info")
Sys.sleep(0.1)
seasonder_log("Second log entry", "info")
# Split logs into blocks (using a 1-second threshold)
blocks <- seasonder_splitLog(threshold = as.difftime(300, units = "secs"))
str(blocks)
}
