% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_validateCSHeaderStructure}
\alias{seasonder_validateCSHeaderStructure}
\title{Validate the Header of CrossSpectra Data}
\usage{
seasonder_validateCSHeaderStructure(header)
}
\arguments{
\item{header}{A list representing the header metadata of a cross spectra file.}
}
\value{
Invisible NULL if the header structure is valid. Otherwise, an error is thrown.
}
\description{
This function validates the structure of a header list that is expected to
represent the metadata for a cross spectra file. It checks if the header is
indeed a list and whether mandatory elements, such as the number of range cells
and the number of Doppler cells, are present.
}
\section{Details}{

The function primarily checks for two conditions:
\itemize{
\item Whether the provided header argument is a list.
\item Whether the nRangeCells and nDopplerCells are present in the header.
}
}

\section{Condition Management}{

This function utilizes the \code{rlang} package to manage conditions and provide
detailed and structured condition messages:

\strong{Condition Classes}:
\itemize{
\item \code{seasonder_CS_header_is_not_a_list}: Triggered when the header parameter is not a list.
\item \code{seasonder_CS_missing_nRange_nDoppler_error}: Triggered when either nRangeCells or nDopplerCells is missing from the header.
}
}

\examples{
header <- list(nRangeCells = 100, nDopplerCells = 256)
seasonder_validateCSHeaderStructure(header)
}
