% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{tercile_plot}
\alias{tercile_plot}
\title{Function for plotting terciles}
\usage{
tercile_plot(
  dt,
  data_col = tc_cols(dt),
  mn = NULL,
  low = "orange",
  mid = "cyan",
  high = "green1",
  name = "",
  labels = c("Wetter", "Average", "Drier"),
  na.value = "white",
  extent = NULL,
  expand.x = c(-0.5, 0.5),
  expand.y = c(-0.5, 2),
  dimension_check = TRUE
)
}
\arguments{
\item{dt}{data table}

\item{data_col}{Name of the column containing the observed tercile category}

\item{mn}{optional title for the plot.}

\item{low, mid, high}{colors for the three categories}

\item{name}{optional title for the colorscale}

\item{labels}{How to label the three categories}

\item{na.value}{How to color missing values}

\item{extent}{Optional vector of length 4 specifying the plotting borders in order xmin, xmax, ymin, ymax.}

\item{expand.x, expand.y}{How far should the plotting borders be extended (beyond the data range)?}

\item{dimension_check}{Logical. By default the function checks that there are not multiple values per coordinate
(and subsets to the first level if there are several, e.g. to the first year and month (by appearance in \code{dt}) if \code{dt} contains data for several years and months).}
}
\description{
Function for plotting terciles
}
\examples{
dt = chirps_monthly[month == 12 & lat <0 & year == 2018]
p = tercile_plot(dt = dt)
if(interactive()) plot(p)


}
