% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelectBoost-package.R
\docType{package}
\name{SelectBoost-package}
\alias{SelectBoost-package}
\alias{SelectBoost}
\title{SelectBoost: A General Algorithm to Enhance the Performance of Variable Selection Methods in Correlated Datasets}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

An implementation of the selectboost algorithm (Bertrand et al. 2020, 'Bioinformatics', \doi{10.1093/bioinformatics/btaa855}), which is a general algorithm that improves the precision of any existing variable selection method. This algorithm is based on highly intensive simulations and takes into account the correlation structure of the data. It can either produce a confidence index for variable selection or it can be used in an experimental design planning perspective.
}
\examples{
set.seed(314)
xran=matrix(rnorm(75),15,5)
ybin=sample(0:1,15,replace=TRUE)
yran=rnorm(15)

#For quick test purpose, not meaningful, should be run with greater value of B
#(disabling parallel computing as well)
res.fastboost <- fastboost(xran,yran,B=3,use.parallel=FALSE)

\donttest{
fastboost(xran,yran)
#Customize resampling levels
fastboost(xran,yran,steps.seq=c(.99,.95,.9),c0lim=FALSE)

#Binary logistic regression
fastboost(xran,ybin,func=lasso_cv_glmnet_bin_min)
}

}
\references{
F. Bertrand, I. Aouadi, N. Jung, R. Carapito, L. Vallat, S. Bahram, M. Maumy-Bertrand (2020). SelectBoost: a general algorithm to enhance the performance of variable selection methods in correlated datasets, \emph{Bioinformatics}. \doi{10.1093/bioinformatics/btaa855}

SelectBoost was used to decypher networks in
C. Schleiss, [...], M. Maumy-Bertrand, S. Bahram, F. Bertrand, and L. Vallat. (2021). Temporal multiomic modelling reveals a B-cell receptor proliferative program in chronic lymphocytic leukemia. \emph{Leukemia}.

#' @author This package has been written by Frédéric Bertrand, Myriam
Maumy-Bertrand, Ismail Aouadi and Nicolas Jung.
Maintainer: Frédéric Bertrand <frederic.bertrand@lecnam.net>
}
\seealso{
Useful links:
\itemize{
  \item \url{https://fbertran.github.io/SelectBoost/}
  \item \url{https://github.com/fbertran/SelectBoost/}
  \item Report bugs at \url{https://github.com/fbertran/SelectBoost/issues/}
}

}
\author{
\strong{Maintainer}: Frederic Bertrand \email{frederic.bertrand@lecnam.net} (\href{https://orcid.org/0000-0002-0837-8281}{ORCID})

Authors:
\itemize{
  \item Myriam Maumy-Bertrand \email{myriam.maumy@ehesp.fr} (\href{https://orcid.org/0000-0002-4615-1512}{ORCID})
}

Other contributors:
\itemize{
  \item Ismail Aouadi \email{i.aouadi@unistra.fr} [contributor]
  \item Nicolas Jung \email{nicolas.jung@unistra.fr} [contributor]
}

}
\keyword{internal}
