% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.SensIAT_withingroup_jackknife_results}
\alias{autoplot.SensIAT_withingroup_jackknife_results}
\title{Plot Estimates at Given Times for \code{SensIAT_withingroup_jackknife_results} Objects}
\usage{
\method{autoplot}{SensIAT_withingroup_jackknife_results}(object, width = NULL, ...)
}
\arguments{
\item{object}{A \code{SensIAT_withingroup_jackknife_results} object produced from
\code{SensIAT_jackknife}.}

\item{width}{Width of the dodge for position, default is half the minimum
distance between time evaluation points.}

\item{...}{Ignored.}
}
\value{
A \code{ggplot2} object.
}
\description{
Horizontal axis represents time, and the vertical axis represents the outcome
from the model. Point plotted is the mean estimate, and the error bars
show the 95\% confidence interval using the variance estimated from the jackknife.
}
\examples{
# Note: fitting the jackknife is computationally expensive,
#       so this example is here for reference.
\dontrun{
fitted <-
fit_SensIAT_within_group_model(
    group.data = SensIAT_example_data,
    outcome_modeler = fit_SensIAT_single_index_fixed_coef_model,
    alpha = c(-0.6, -0.3, 0, 0.3, 0.6),
    id = Subject_ID,
    outcome = Outcome,
    time = Time,
    intensity.args=list(bandwidth = 30),
    knots = c(60,260,460),
    End = 830
)
jackknife.estimates <- SensIAT_jackknife(fitted, time = c(90, 180, 270, 360, 450))
ggplot2::autoplot(jackknife.estimates)
}
}
