% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Demography_functions.R
\name{Simulate_demography}
\alias{Simulate_demography}
\title{Monte Carlo simulations of Leslie matrix models}
\usage{
Simulate_demography(
  n,
  data,
  AALC = NULL,
  AAFC = NULL,
  F. = 0,
  M.estimators = NULL,
  Verbatim = TRUE
)
}
\arguments{
\item{n}{The number of specified Monte Carlo simulations to run}

\item{data}{A multi-level list of the class `Demography.inputs` produced from the
`create_data_input` function and then manually completed.}

\item{AALC}{Age-at-last-capture which can be specified by the user. Must be an integer
age which can include zero.}

\item{AAFC}{Age-at-first-capture which can be specified by the user.Must be an integer
age which can include zero to indicate the availability of the population to capture from birth.}

\item{F.}{The instantaneous rate of fishing mortality 'F'. This will be applied to all
ages available to capture as defined by either the AALC or AAFC arguments.}

\item{M.estimators}{Any specific natural mortality estimators to be included in the analysis.
Only one will be used in each run which is randomly selected. Must be a single estimator
or a vector of estimators. These can include: "Pet.Wro","Jensen.mat","Chen.Yuan",
"Then_hoenig","Then_pauly", "Jensen.mat","Charnov" or "Chen.Want". If none are specified
then all applicable estimators could be chosen.}

\item{Verbatim}{Print summary results to screen if TRUE. When FALSE, the progress bar is also disabled.}
}
\value{
A list with two data.frames. The first is the summary of the Monte Carlo simulations
    for all parameters calculated by the `Calculate_demography` function with mean and
    95\% quantiles. The second is all of the results for each parameter from individual
    simulations so that their distributions can be interrogated further.
}
\description{
This is a wrapper function for `Calculate_demography` which runs this function
    the specified number of times.
}
\examples{
# load Silky shark data produced by create_data_input()
# Type `?create_data_input()` for details
data("Silky_data")

# Run function to get conduct Monte Carlo Simulations using
# `Calculate_demography()`  for all available natural mortality estimators.
# Set n = at least 1000 for full analysis but use n = 100 for testing

Simulate_demography(n = 100, Silky_data)
}
