% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ShinyTester.R
\name{ShinyHierarchy}
\alias{ShinyHierarchy}
\title{ShinyHierarchy}
\usage{
ShinyHierarchy(directory = getwd(), ui = "ui.R", server = "server.R",
  offsetReactives = T)
}
\arguments{
\item{directory}{the directory or website containing the files for the Shiny App. Defaults to current working directory}

\item{ui}{a character vector size 1 containing the name of the UI files. defaults to "ui.R"}

\item{server}{a character vector size 1 containing the names of the SERVER file. defaults to "server.R"}

\item{offsetReactives}{a boolean that specifies if the middle row (the reactives) should show up in one row or whether there
should be a small offset. TRUE by default.}
}
\value{
It returns a very very nice network chart with BASICALLY three-ish ROWS of nodes.
The first one is the UI Inputs, the middle row(s) are the reactives, and the last row are the outputs
being visualized. The hesitation for the second row (the reactives) is because I have introduced a small offset
 to each node in the middle row in order to see reactive flows into each other (if they are all in the same row,
 you can't really see them). You can avoid this behavior by setting the parameter offsetReactives = F.
}
\description{
Create a hierarchical network chart that  shows the _ad hoc_ structure of your shiny Server.
}
\details{
You can test with your own app, go to your shiny app, make that your
 working directory, and then type `ShinyHierarchy()`
}
\examples{
ShinyHierarchy(system.file("example", package = "ShinyTester"))
}

