% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrinkcovmat.unequal.R
\name{shrinkcovmat.unequal-deprecated}
\alias{shrinkcovmat.unequal-deprecated}
\title{Shrinking the Sample Covariance Matrix Towards a Diagonal Matrix with
Diagonal Elements the Sample Variances.}
\usage{
shrinkcovmat.unequal(data, centered)
}
\arguments{
\item{data}{a numeric matrix containing the data.}

\item{centered}{a logical indicating if the vectors are centered around
their mean vector.}
}
\value{
Returns an object of the class 'shrinkcovmathat' that has
components: \item{Sigmahat}{The Stein-type shrinkage estimator of the
covariance matrix.} \item{lambdahat}{The estimated optimal shrinkage
intensity.} \item{Sigmasample}{The sample covariance matrix.}
\item{Target}{The target covariance matrix.} \item{centered}{If the data are
centered around their mean vector.}
}
\description{
Provides a nonparametric Stein-type shrinkage estimator of the covariance
matrix that is a linear combination of the sample covariance matrix and of
the diagonal matrix with elements the corresponding sample variances on the
diagonal and zeros elsewhere.
}
\details{
The rows of the data matrix \code{data} correspond to variables and the
columns to subjects.
}
\references{
Touloumis, A. (2015) nonparametric Stein-type Shrinkage
Covariance Matrix Estimators in High-Dimensional Settings.
\emph{Computational Statistics & Data Analysis} \bold{83}, 251--261.
}
\seealso{
\code{\link{ShrinkCovMat-deprecated}}
}
\author{
Anestis Touloumis
}
\keyword{internal}
