# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' EstNull
#' This function is a Rcpp version of Wenguang Sun and Tony T. Cai's
#' EstNull.func R function, estimating null distribution from data.
#' Sun, W., & Cai, T. T. (2007). Oracle and Adaptive Compound Decision
#' Rules for False Discovery Rate Control.
#' Journal of the American Statistical Association,
#' 102(479), 901–912.
#' @author Qi Gao
#' @param x Input vector of all coexpression values
#' @param gamma Parameter setting the stopping threshold
#' @return List of mean and std
#' @export
EstNull <- function(x, gamma = 0.1) {
    .Call(`_SiFINeT_EstNull`, x, gamma)
}

#' cal_coexp
#' This function calculates the coexpression patterns between genes
#' and returns the coexpression matrix.
#' @author Qi Gao
#' @param X Input binarized cell (row) by gene (column) matrix
#' @return Coexpression matrix
#' @export
cal_coexp <- function(X) {
    .Call(`_SiFINeT_cal_coexp`, X)
}

#' cal_coexp_sp
#' This function calculates the coexpression patterns between genes
#' in sparse matrix and returns the coexpression matrix.
#' @author Qi Gao
#' @param X Input binarized cell (row) by gene (column) sparse matrix
#' @return Coexpression matrix
#' @export
cal_coexp_sp <- function(X) {
    .Call(`_SiFINeT_cal_coexp_sp`, X)
}

#' cal_conn
#' This function calculates the first 3 order connectivities for each gene
#' and returns the list of vectors of connectivities.
#' @author Qi Gao
#' @param data Input gene by gene coexpression matrix
#' @param thres Gene pairs with coexpression exceed thres would be assigned an
#'        edge between them in the coexpression network
#' @param m Sample size used for the calculation of 3rd order connectivities
#' @param abso Whether to calculate connectivities in absolute network (TRUE)
#'        or positive network (FALSE)
#' @param niter Number of sample used for the calculation of 3rd order
#'        connectivities
#' @return List of connectivities C1, C2, and C3 ' @export
cal_conn <- function(data, thres = 3, m = 10L, abso = 1L, niter = 100L) {
    .Call(`_SiFINeT_cal_conn`, data, thres, m, abso, niter)
}

