% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix.plot.R
\name{fix.plot}
\alias{fix.plot}
\title{Plot Results of Estimating}
\usage{
fix.plot(res.fix.fit, type, title = "")
}
\arguments{
\item{res.fix.fit}{the output from fix.fit() function}

\item{type}{type indicates which type of basis is used (There are 31 types in this package)}

\item{title}{give the title for the fixed estimate plot}
}
\value{
A list which contains 3 plot related to the estimation of coefficient, Elbow point and cross validation in order
}
\description{
fix.plot() visualizes the estimation of coefficient.
}
\examples{
set.seed(137)
time.series = c()
n = 1024
v = 25
w = rnorm(n, 0, 1) / v
x_ini = runif(1,0,1)
for(i in 1:n){
  if(i == 1){
    time.series[i] = 0.2 + 0.6*cos(2*pi*(i/n))*x_ini  + w[i] #
  } else{
    time.series[i] = 0.2 + 0.6*cos(2*pi*(i/n))*time.series[i-1] + w[i]
  }
}

res1 = fix.fit(time.series, 5, 1, type = "Legen")
fix.plot(res1, "Legen")
}
