% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sie.predict.R
\name{sie.predict}
\alias{sie.predict}
\title{Predicting Time Series With H Steps}
\usage{
sie.predict(ts, esti.li, h)
}
\arguments{
\item{ts}{The data set which is a time series data typically}

\item{esti.li}{The output from fix.fit() or sie.auto.fit() function}

\item{h}{h indicates the number of forecasting points}
}
\value{
A vector which contains h forecasting points
}
\description{
predict.nts() predicts the time series data basis on the estimation.
}
\examples{
set.seed(137)
time.series = c()
n = 1024
v = 25
w = rnorm(n, 0, 1) / v
x_ini = runif(1,0,1)
for(i in 1:n){
  if(i == 1){
    time.series[i] = 0.2 + 0.6*cos(2*pi*(i/n))*x_ini  + w[i] #
  } else{
    time.series[i] = 0.2 + 0.6*cos(2*pi*(i/n))*time.series[i-1] + w[i]
  }
}
res1.2 = fix.fit(time.series, 5, 1, "Legen")
sie.predict(time.series, res1.2, 5)
}
