% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.sightability.model.args.R
\name{check.sightability.model.args}
\alias{check.sightability.model.args}
\title{Check the sightability model arguments for consistency}
\usage{
check.sightability.model.args(data, sight.model, sight.beta, sight.beta.cov)
}
\arguments{
\item{data}{Data.frame containing covariates for sightability model}

\item{sight.model}{Formula with sightability model}

\item{sight.beta}{Parameter estimates (from fitted sightability model}

\item{sight.beta.cov}{Estimated variance-covariance matrix for  parameter estimates
from fitted sightability model.}
}
\value{
Error condition or invisible
}
\description{
Check the sightability model arguments for consistency
}
\examples{
sightability.table <- data.frame(VegCoverClass=1:5)
sight.beta <- c(4.2138, -1.5847)
sight.beta.cov <- matrix(c(0.7821634, -0.2820000,-0.2820000,  0.1114892), nrow=2)
check.sightability.model.args( sightability.table, 
                               ~VegCoverClass, 
                               sight.beta, 
                               sight.beta.cov)
\dontrun{
check.sightability.model.args( sightability.table, 
                              ~VegCoverClass2, 
                              sight.beta,
                              sight.beta.cov)
check.sightability.model.args( sightability.table, 
                               ~VegCoverClass,
                                sight.beta[1],
                               sight.beta.cov)
}

}
\author{
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
\keyword{methods}
