% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.SimCop.R
\name{plot.SimCop}
\alias{plot.SimCop}
\alias{persp3d.SimCop}
\title{Plot a bivariate copula or its density}
\usage{
\method{plot}{SimCop}(x, ...)

\method{persp3d}{SimCop}(
  x,
  ...,
  type = c("cdf", "pdf"),
  nx = 129,
  ny = 129,
  col = heat.colors(100),
  qcut = 0.95,
  cut,
  xlab = expression(u[1]),
  ylab = expression(u[2])
)
}
\arguments{
\item{x}{an object of \code{\link{class}} \sQuote{SimCop}.}

\item{\dots}{additional arguments passed to \code{\link[rgl]{persp3d}}.}

\item{type}{specifies whether the copula (\dQuote{\code{cdf}}) or its probability density function (\dQuote{\code{pdf}}) is plotted; see \sQuote{Details}. Can be abbreviated.}

\item{nx, ny}{length of grids that define the gridlines on which the plotted function is evaluated.}

\item{col}{colour scheme to use for the surface; see \sQuote{Details}.}

\item{qcut, cut}{used if \code{type} is \dQuote{\code{pdf}}; see \sQuote{Details}.}

\item{xlab, ylab}{default labels for the two axes.}
}
\value{
Returns a list with four components \link[=invisible]{invisibly}.  Components \code{x} and \code{y} contain the location of grid lines at which the function was evaluate.  Component \code{z} contains the function evaluations (possibly truncated) and component \code{col} contains the col used.
}
\description{
Plot a bivariate copula or its density function.  Essentially hands over immediately to \code{\link[rgl]{persp3d}}.
}
\details{
If \code{type} is \dQuote{\code{pdf}}, then \code{x} must have a function with name \dQuote{\code{pdfCopula}} in its environment which evaluates the probability density function of the copula stored in \code{x}.

For plotting the copula, the \dQuote{x}-grid and \dQuote{y}-grid are produced by using, respectively,  \code{nx} and \code{ny} equispaced points between 0 and 1 (inclusive).  To avoid evaluating the density function at the boundary, if \code{type} is \dQuote{\code{pdf}}, then grids are initially generated in the same manner, after which the first grid point is removed and all remaining grid points are shifted towards the origin by half the distance between two neighbouring grid points.

The function to be plotted is evaluated at all possible combination of the grid points.  As the function values of the density function can be large, in particular for extreme value copulae, the values are truncated using either \code{cut} (absolute value) or \code{qcut} (corresponding quantile of all values as determined by the \code{\link{quantile}} function).

Finally, the colour scheme passed by argument \code{col} is used to assign a colour to every point at which the function was evaluated by linearly mapping the function values onto the provided colours.
}
\examples{
Cop1 <- NewMVFrankCopula(2)
plot(Cop1)
plot(Cop1, type = "p", qcut = 1)

}
\author{
Berwin A Turlach \email{berwin.turlach@gmail.com}
}
\keyword{hplot}
