% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimTimeVar.R
\name{override_static}
\alias{override_static}
\title{Override static variable}
\usage{
override_static(.static.var.name, .id.var.name = "id", .d, .obs)
}
\arguments{
\item{.static.var.name}{Name of static variable.}

\item{.id.var.name}{Name of variable defining clusters in dataset.}

\item{.d}{Dataset}

\item{.obs}{The number of observations per cluster.}
}
\description{
An internal function not intended for the user. For static variables, overrides any time-varying
values to ensure that they are actually static.
}
\examples{
# example with 10 subjects each with 3 observations
# generate sex in a way where it might vary within a subject
data = data.frame( id = rep(1:10, each=3),
                   male = rbinom( n=10*3, size=1, prob=0.5 ) )
override_static("male", "id", data, 3)
}
