% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EulerCharacteristic.R
\name{euler_characteristic}
\alias{euler_characteristic}
\title{Compute the Euler characteristic \eqn{\chi} of a simplicial complex}
\usage{
euler_characteristic(simplices, tol)
}
\arguments{
\item{simplices}{A list of simplices (each a numeric vector).}

\item{tol}{Optional numerical tolerance to pass to \code{rankMatrix()}.}
}
\value{
An integer representing the Euler characteristic \eqn{\chi}.
}
\description{
Compute the Euler characteristic \eqn{\chi} of a simplicial complex
}
\details{
The Euler characteristic is computed as:
\deqn{\chi = \sum_{k=0}^{k_{\max}} (-1)^k \beta_k}
where \eqn{\beta_k} is the \eqn{k}th Betti number, and \eqn{k_{\max}} is the highest dimension of any simplex in the complex.

Interpretation of values:
\itemize{
  \item \eqn{\chi = 2}: Sphere-like surfaces
  \item \eqn{\chi = 1}: Disk-like spaces
  \item \eqn{\chi = 0}: Torus-like or circle-like spaces
  \item \eqn{\chi < 0}: Surfaces with multiple handles or genus
}
}
\examples{
simplices <- list(c(1, 2), c(3, 4), c(2, 1, 3), c(4, 2))
euler_characteristic(simplices, tol=0.1)
}
\seealso{
\code{\link{betti_number}}
}
