% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_exact_agreement.R
\name{power_agreement_exact}
\alias{power_agreement_exact}
\title{Power Calculation for Exact Agreement/Tolerance Test}
\usage{
power_agreement_exact(
  n = NULL,
  delta = NULL,
  mu = 0,
  sigma = NULL,
  p0_star = 0.95,
  power = NULL,
  alpha = 0.05,
  max_iter = 1000
)
}
\arguments{
\item{n}{Number of subject pairs (sample size)}

\item{delta}{Maximum allowable difference bound (half-width of tolerance interval)}

\item{mu}{Mean of paired differences}

\item{sigma}{Standard deviation of paired differences}

\item{p0_star}{The coverage proportion (content) of the tolerance interval. Central proportion under null hypothesis (default = 0.95)}

\item{power}{Target power (probability of rejecting false null)}

\item{alpha}{Significance level (Type I error rate, default = 0.05, Confidence level = 1-alpha)}

\item{max_iter}{Maximum iterations for gamma computation (default = 1000)}
}
\value{
An object of class "power.htest", a list with components:
\item{n}{Sample size}
\item{delta}{c}
\item{mu}{Mean of differences}
\item{sigma}{Standard deviation of differences}
\item{p0_star}{Central proportion (null hypothesis)}
\item{p1_star}{Central proportion (alternative hypothesis)}
\item{alpha}{Significance level}
\item{power}{Power of the test}
\item{critical_value}{Critical value for test statistic}
\item{method}{Description of the method}
\item{note}{Additional notes}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

Computes sample size, power, or other parameters for the exact method of
assessing agreement between two measurement methods, as described in
Shieh (2019). This method tests whether the central portion of paired
differences falls within specified bounds. This \emph{roughly} equates to the power for tolerance limits.
}
\details{
This function implements the exact agreement test procedure of Shieh (2019)
for method comparison studies. The test evaluates whether the central
proportion of the distribution of paired differences lies within the
interval [-delta, delta].

The null hypothesis is: H0: theta_(1-p) <= -delta or delta <= theta_p
The alternative is: H1: -delta < theta_(1-p) and theta_p < delta

where p = (1 + p0_star)/2, and theta_p represents the 100p-th percentile
of the paired differences.

Specify three of: n, delta, power, and sigma. The fourth will be calculated.
If mu is not specified, it defaults to 0.

Tolerance Interval Interpretation:

The parameter \code{p0_star} represents the tolerance coverage proportion,
i.e., the proportion of the population that must fall within the specified
bounds [-delta, delta] under the null hypothesis. This is conceptually
related to tolerance intervals, but formulated as a
hypothesis test rather than an estimation problem.

Note: This differs from Bland-Altman's "95\% limits of agreement," which
are confidence intervals for the 2.5th and 97.5th percentiles, \emph{not}
tolerance intervals.
}
\examples{
# Example 1: Find required sample size
power_agreement_exact(delta = 7, mu = 0.5, sigma = 2.5,
                      p0_star = 0.95, power = 0.80, alpha = 0.05)

# Example 2: Calculate power for given sample size
power_agreement_exact(n = 15, delta = 0.1, mu = 0.011,
                      sigma = 0.044, p0_star = 0.80, alpha = 0.05)

# Example 3: Find required delta for given power and sample size
power_agreement_exact(n = 50, mu = 0, sigma = 2.5,
                      p0_star = 0.95, power = 0.90, alpha = 0.05)

}
\references{
Shieh, G. (2019). Assessing Agreement Between Two Methods of Quantitative
Measurements: Exact Test Procedure and Sample Size Calculation.
Statistics in Biopharmaceutical Research, 12(3), 352-359.
https://doi.org/10.1080/19466315.2019.1677495
}
