% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{Autoplot implementations}
\alias{Autoplot implementations}
\alias{autoplot}
\alias{autoplot.sobol_result}
\alias{autoplot.sobol}
\alias{autoplot.sobol2007}
\alias{autoplot.soboljansen}
\alias{autoplot.sobolEff}
\alias{autoplot.sobolmartinez}
\alias{autoplot.sobol_summary}
\title{Autoplot implementations}
\usage{
autoplot(object, ...)

\method{autoplot}{sobol_result}(
  object,
  show_uncertainty = FALSE,
  probs = c(0.1, 0.9),
  bootstrap = 200L,
  ...
)

\method{autoplot}{sobol}(object, separate_panels = TRUE, ncol = 2, ...)

\method{autoplot}{sobol2007}(object, ...)

\method{autoplot}{soboljansen}(object, ...)

\method{autoplot}{sobolEff}(object, ...)

\method{autoplot}{sobolmartinez}(object, ...)

\method{autoplot}{sobol_summary}(object, ...)
}
\arguments{
\item{object}{A \code{sobol_result}, \code{sobol_summary}, or
\code{sensitivity::sobol} instance.}

\item{...}{Further arguments passed to the plotting backend.}

\item{show_uncertainty}{Logical, when \code{TRUE} bootstrap quantiles are
computed (if available) and displayed as error bars.}

\item{probs}{Numeric vector of probabilities used for the uncertainty bars.}

\item{bootstrap}{Integer indicating how many bootstrap resamples to draw when
\code{show_uncertainty = TRUE}.}

\item{separate_panels}{Should the indices be plotted on separate
panels according to their order?
If \code{separate_panels = TRUE}, the first order indices are separated from
the higher orders ones.}

\item{ncol}{If \code{separate_panels = TRUE}, the number of columns for the
facet wrapping of the plot.}
}
\value{
A ggplot object when \code{ggplot2} is installed, otherwise the
bar centres invisibly.
}
\description{
Provide a ggplot visualisation when ggplot2 is available, otherwise fallback
to a lightweight base R bar chart. Supports the custom \code{sobol_result} class
used in this package, compact \code{sobol_summary} data frames, and
\code{sensitivity::sobol} objects.
}
