% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol4r_simmer_wrappers.R
\name{sobol4r_mm1_model}
\alias{sobol4r_mm1_model}
\title{M/M/1 queue model wrapper for Sobol designs}
\usage{
sobol4r_mm1_model(X, horizon = 1000, warmup = 200, nrep = 20L)
}
\arguments{
\item{X}{Design matrix or data.frame with columns \code{lambda} (arrival
rate) and \code{mu} (service rate).}

\item{horizon}{Simulation horizon.}

\item{warmup}{Warmup period; arrivals ending before this time are discarded
from the summary statistic.}

\item{nrep}{Number of replications used to average the mean time in system.}
}
\value{
Numeric vector of length \code{nrow(X)}.
}
\description{
Evaluate a simple M/M/1 queue built with \pkg{simmer} for each row of a
Sobol design matrix. The quantity of interest is the mean time in system
across \code{nrep} independent replications.
}
