% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kcap.R
\name{Kcap}
\alias{Kcap}
\title{Relative capillary conductivity}
\usage{
Kcap(suc, par.shp, suc.negativ = TRUE, modality = "uni")
}
\arguments{
\item{suc}{Suction/pressure heads. Negative if suc.negativ = TRUE}

\item{par.shp}{named parameter in list or vector}

\item{suc.negativ}{set TRUE if suction/pressure heads are negative and FALSE if positive}

\item{modality}{pore size distributions ('uni' or 'bi')}
}
\description{
Relative capillary conductivity based on Mualem's conductivity model for unimodal or bimodal van Genuchten-Mualem.
}
\details{
\describe{\item{par.shp:}{
alfa [1/L]: van Genuchten shape parameter \cr
n [-]: van Genuchten shape parameter \cr
m [-]: shape parameter (m = 1-(1/n) if missing) \cr
tau [-]:  tortuosity and connectivity parameter (minimum -1 or -2 for the PDI model; for details see Peters (2014)) \cr
h0 [L]: suction at water content of 0 (i.e. oven dryness) (h0 = 10^6.8 if missing, corresponding to oven dryness at 105°C (Schneider and Goss, 2012))}
\item{par.shp: additional parameter for bimodal (modality == 'bi')}{
w2 [-]: weigthing between pore space distribution \cr
alfa2 [1/L]: van Genuchten parameter alfa for second pore space distribution \cr
n2 [-]: van Genuchten parameter n for second pore space distribution}}
}
\references{
Peters, A. (2014). Reply to comment by S. Iden and W. Durner on Simple consistent models for water retention and hydraulic conductivity in the complete moisture range. Water Resour. Res. 50, 7535–7539.

Van Genuchten, M. T. (1980). A closed-form equation for predicting the hydraulic conductivity of unsaturated soils. Soil science society of America journal, 44(5), 892-898.

Mualem, Y. (1976). A new model for predicting the hydraulic conductivity of unsaturated porous media. Water resources research, 12(3), 513-522.

Schneider, M., & Goss, K. U. (2012). Prediction of the water sorption isotherm in air dry soils. Geoderma, 170, 64-69.
}
\seealso{
\code{\link{Ku}}
}
