% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_management_df.R
\name{plot_management_df}
\alias{plot_management_df}
\title{Plot a management dataframe}
\usage{
plot_management_df(management_df, title = "Management Timeline")
}
\arguments{
\item{management_df}{a management data frame}

\item{title}{the title of the plot}
}
\value{
a plot
}
\description{
Visual representation of a management_df.
}
\details{
The colors in the background represent the soil cover by main crops (dark green),
cover crops (light green), and crop residues (brown). 
"T" indicates tillage event with a STIR value >= 0.
"P" indicates a crop protection event.
The values in the middle indicate C inputs into the soil system im MgC/ha, either 
by crops (C), residue removal (R), cover crops (CC) or organic amendments (OA). 
Negative values are withdrawls by residue removal.
Dotted vertical lines represent sowing events, the sown crop or cover crop
is noted in the lowest quarter at the right side of the line.
Note that large management_df can be heavy to compute and the plots may be
messy.
}
\examples{

\donttest{
  # creates a visual representation of the EXAMPLE data
  plot_management_df(EXAMPLE_data)
 }
}
