% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higherTaxaCodes.R
\name{decompose_taxon_code}
\alias{decompose_taxon_code}
\title{Decompose taxon letter codes}
\usage{
decompose_taxon_code(codes)
}
\arguments{
\item{codes}{A character vector of taxon codes to "decompose" -- case sensitive}
}
\value{
A list with equal length to input vector; one character vector per element
}
\description{
Find all codes that logically comprise the specified codes. For instance, code "ABC" ("Anhyturbels") returns "A" ("Gelisols"), "AB" ("Turbels"), "ABC" ("Anhyturbels"). Use in conjunction with a lookup table that maps Order, Suborder, Great Group and Subgroup taxa to their codes (see \code{\link{taxon_code_to_taxon}} and \code{\link{taxon_to_taxon_code}}).
}
\details{
Accounts for Keys that run out of capital letters (more than 26 subgroups) and use lowercase letters for a unique subdivision within the "fourth character position."
}
\examples{

decompose_taxon_code(c("ABC", "ABCDe", "BCDEf"))

}
\seealso{
\code{\link{preceding_taxon_codes}}, \code{\link{taxon_code_to_taxon}}, \code{\link{taxon_to_taxon_code}}
}
