% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pheno}
\alias{pheno}
\title{Phenotype}
\format{
A data frame in tidy format with 39,006 observations on the following 13 variables:
\describe{
\item{\code{year}}{years, 31 levels (1989 - 2019)}
\item{\code{location}}{locations, 63 levels (observed locations in the historical series)}
\item{\code{latitude}}{latitude}
\item{\code{longitude}}{longitude}
\item{\code{altitude}}{altitude}
\item{\code{trial}}{name of the trial that originated the phenotypic record}
\item{\code{check}}{indicator variable for variety checks, 2 levels (yes or no)}
\item{\code{maturity_group}}{genotype's maturity group, 2 levels (II or III)}
\item{\code{G}}{genotype, 4,257 levels}
\item{\code{eBLUE}}{empirical best linear unbiased estimate of genotype means}
\item{\code{SE}}{standard error of genotype means on a location level}
\item{\code{average_planting_date}}{average planting date on a location level (MM/DD/YY)}
\item{\code{average_maturity_date}}{average maturity date on a location level in days after planting}
}
}
\source{
\describe{
Krause, M. D., Dias, K. O. G., Singh, A. K., and Beavis. W. D. (2022). Using large
soybean historical data to study genotype by environment variation and
identify mega-environments with the integration of genetic and non-genetic
factors. bioRxiv, \doi{doi:10.1101/2022.04.11.487885}
}
}
\usage{
pheno
}
\description{
Modeled data set by Krause et al. (2022) from the USDA Northern Region
Uniform Soybean Tests. The data contains 4,257 experimental genotypes
evaluated at 63 locations and 31 years resulting
in 591 location-year combinations (environments) with 39,006 yield values
belonging to matirity groups II and III from 1989 to 2019. Annual PDF
reports from the Northern Region of the USDA Uniform Soybean Tests
were obtained from \url{https://ars.usda.gov/mwa/lafayette/cppcru/ust}.
The data retrieved from the published PDF files represent averages for seed
yield for each genotype evaluated at each trial in location-year combinations.
Seed yield was adjusted to 13\% moisture and results were reported in bushels
per acre (bu/ac). For more information about the trial field plot design and
agronomic practices, please refer to the PDF files. The raw data can also be
downloaded from Soybase: \url{https://soybase.org/ncsrp/queryportal/}.
}
\keyword{datasets}
