% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\name{inputObjects}
\alias{inputObjects}
\alias{simList-accessors-metadata}
\alias{inputObjects,simList-method}
\alias{inputObjects,missing-method}
\alias{outputObjects}
\alias{outputObjects,simList-method}
\alias{outputObjects,missing-method}
\alias{outputObjectNames}
\alias{outputObjectNames,simList-method}
\alias{reqdPkgs}
\alias{reqdPkgs,simList-method}
\alias{reqdPkgs,missing-method}
\alias{documentation}
\alias{documentation,simList-method}
\alias{sessInfo}
\alias{sessInfo,simList-method}
\title{Metadata accessors}
\usage{
inputObjects(sim, module, path)

\S4method{inputObjects}{simList}(sim, module, path)

\S4method{inputObjects}{missing}(sim, module, path)

outputObjects(sim, module, path)

\S4method{outputObjects}{simList}(sim, module, path)

\S4method{outputObjects}{missing}(sim, module, path)

outputObjectNames(sim, module)

\S4method{outputObjectNames}{simList}(sim, module)

reqdPkgs(sim, module, modulePath)

\S4method{reqdPkgs}{simList}(sim, module, modulePath)

\S4method{reqdPkgs}{missing}(sim, module, modulePath)

documentation(sim, module)

\S4method{documentation}{simList}(sim, module)

sessInfo(sim)

\S4method{sessInfo}{simList}(sim)
}
\arguments{
\item{sim}{A \code{simList} object from which to extract element(s) or in which to replace element(s).}

\item{module}{Character vector of module name(s)}

\item{path}{The path to the module., i.e., the \code{modulePath}.
Only relevant if \code{sim} not supplied.}

\item{modulePath}{That path where \code{module} can be found. If set already
using \code{setPaths}, it will use that. This will be ignored if \code{sim}
is supplied and is required if \code{sim} not supplied}
}
\description{
These accessors extract the metadata for a module (if specified) or all modules
in a \code{simList} if not specified.
}
\examples{
\donttest{
# set modulePath
setPaths(modulePath = getSampleModules(tempdir()))
# use Require and reqdPkgs
pkgs <- reqdPkgs(module = c("caribouMovement", "randomLandscapes", "fireSpread"))
}
}
