% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_functions.R
\name{ng_kernel}
\alias{ng_kernel}
\title{ng_kernel: Kernel from the Ng spectral clustering algorithm}
\usage{
ng_kernel(data, sigma = 0.1)
}
\arguments{
\item{data}{Data frame or matrix: with points as columns, features as rows}

\item{sigma}{Numerical value: a global sigma that controls the drop off in affinity}
}
\value{
A similarity matrix of the input data
}
\description{
This is the kernel from the Ng spectral clustering algorithm. It takes a global
sigma which requires tuning for new datasets in most cases. It is possible to use
the sigma_finder function to find a sigma for a dataset. Sigma is assumed to be
squared already.
}
\examples{
ng_similarity <- ng_kernel(brain[[1]])
}
\references{
Ng, Andrew Y., Michael I. Jordan, and Yair Weiss. "On spectral clustering: 
Analysis and an algorithm." Advances in neural information processing systems. 2002.
}
