% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residualsfitStMoMo.R
\name{residuals.fitStMoMo}
\alias{residuals.fitStMoMo}
\title{Extract deviance residuals of a Stochastic Mortality Model}
\usage{
\method{residuals}{fitStMoMo}(object, scale = TRUE, ...)
}
\arguments{
\item{object}{an object of class \code{"fitStMoMo"} with the fitted 
parameters of a stochastic mortality model.}

\item{scale}{logical indicating whether the residuals should be scaled 
or not by dividing the deviance by the  overdispersion of the model.  
Default is \code{TRUE}.}

\item{...}{other arguments.}
}
\value{
An object of class \code{"resStMoMo"} with the residuals. This 
object has components:
  \item{residuals}{ a matrix with the residuals.}
  \item{ages}{ ages corresponding to the rows in \code{residuals}.}
  \item{years}{ years corresponding to the columns in \code{residuals}.}
}
\description{
Compute deviance residuals of a fitted Stochastic Mortality Model. 
These residuals can be plotted using \code{\link{plot.resStMoMo}}.
}
\examples{
CBDfit <- fit(cbd(), data = central2initial(EWMaleData), ages.fit = 55:89)
CBDres <- residuals(CBDfit)
plot(CBDres)
}
\seealso{
\code{\link{plot.resStMoMo}}
}
