% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_taphonomy.R
\name{apply_taphonomy}
\alias{apply_taphonomy}
\title{model taphonomic effects}
\usage{
apply_taphonomy(x, pres_potential, ctc)
}
\arguments{
\item{x}{event type data, e.g. times/ages of fossil occurrences or their stratigraphic position, or a \code{pre_paleoTS}, \code{fossils}, or \code{char_mat} object.}

\item{pres_potential}{function. Takes taphonomic conditions as input and returns the preservation potential (a number between 0 and 1). Must be vectorized, meaning if given a vector, it must return a vector of equal length.}

\item{ctc}{function, change in taphonomic conditions (ctc) with time or stratigraphic position. . Must be vectorized, meaning if given a vector, it must return a vector of equal length.}
}
\value{
if given event type data, a numeric vector, location/timing of events (e.g. fossil occurrences) after the taphonomic filter is applied. If given a \code{pre_paleoTS} object, returns another \code{pre_paleoTS} object with reduced number of specimens. If given a \code{fossils} object as created by the \code{FossilSim} package, returns another \code{fossils} object with some occurrences removed according to preservation potential.
}
\description{
Models taphonomy by combining the change in taphonomic conditions with the preservation potential as a function of taphonomic conditions to determine how preservation potential changes. This is then used to systematically remove (thin) the event data using \code{thin}/ remove specimens from the \code{pre_paleoTS} object using \code{prob_remove}.
}
\examples{

# see
#vignette("advanced_functionality")
# for details on usage
# or the documentation of apply_ecology for equivalent application to ecology

}
\seealso{
\itemize{
\item \code{\link[=apply_niche]{apply_niche()}} for modeling niche preferences based on the same principle. Internally, these functions are structured identically.
\item \code{\link[=thin]{thin()}} and \code{\link[=prob_remove]{prob_remove()}} for the underlying mathematical procedures.
\item \code{\link[=perfect_preservation]{perfect_preservation()}} and \code{\link[=all_preserved]{all_preserved()}} to model perfect preservation of fossils
\item \code{\link[=strat_filter]{strat_filter()}} for simple stratigraphic filtering in the time domain as taphonomic effect
\item \code{\link[=as_char_mat]{as_char_mat()}} to construct character matrices associated with stratigraphic information
}
}
