% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeostTextureLibrarySharedRoxy.R
\name{RRIMin}
\alias{RRIMin}
\alias{RRIMin.numeric}
\alias{RRIMin.SpatRaster}
\title{RRIMin: Minimum Radial Roughness index}
\usage{
RRIMin(x, ...)

\method{RRIMin}{numeric}(x, ...)

\method{RRIMin}{SpatRaster}(x, ..., .method = c("rcpp", "r"))
}
\arguments{
\item{x}{A DEM as a SpatRaster or a vector of numeric values from a focal window in a DEM from which to compute the index}

\item{...}{reserved for future use}

\item{.method}{Either \code{r} or \code{rcpp} (fast batch processing using C++, still to implement)}
}
\value{
isotropic roughness (in the same units of input)
}
\description{
Same as RRI but instead of computing the mean of the absolute differences of order 2,
the minimum is computed.
The input is the DEM (no need to detrend).
}
\examples{
library(terra)
dem= rast(paste(system.file("extdata", package = "SurfRough"), "/trento1.tif",sep=""))
roughRRImin=RRIMin(dem)
plot(roughRRImin)
}
\references{
Trevisani S., Teza G., Guth P.L., 2023. Hacking the topographic ruggedness index. Geomorphology
https://doi.org/10.1016/j.geomorph.2023.108838
}
