% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeostTextureLibrarySharedRoxy.R
\name{circularDispersionGV}
\alias{circularDispersionGV}
\title{Compute circular variance of aspect (i.e. of the gradient vector)}
\usage{
circularDispersionGV(inraster, window)
}
\arguments{
\item{inraster}{The DEM/image from which compute the index}

\item{window}{The moving window adopted for computing the index}
}
\value{
The raster with the computed index
}
\description{
Compute circular variance of aspect (i.e. of the gradient vector)
}
\examples{
# Gradient vector dispersion using a circular search window of radius 3.
library(terra)
dem=rast(paste(system.file("extdata", package = "SurfRough"), "/trento1.tif",sep=""))
w=KernelCircular(3)
roughGrad=circularDispersionGV(dem,w)
plot(roughGrad)
}
