% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div.R
\name{div}
\alias{div}
\title{Divide Columns}
\usage{
div(x, cols, by = 1000, grep = FALSE, ...)
}
\arguments{
\item{x}{a data frame.}

\item{cols}{column names, or column indices.}

\item{by}{a number to divide with.}

\item{grep}{whether \code{cols} is a regular expression.}

\item{...}{passed to \code{grep()}.}
}
\value{
A data frame similar to \code{x}, after dividing columns \code{cols} by the
number \code{by}.
}
\description{
Divide column values in a data frame with a common number.
}
\note{
Provides notation that is convenient for modifying many columns at once.
}
\examples{
# These are equivalent:

x1 <- div(summary.taf, c("Rec","Rec_lo","Rec_hi",
                         "TSB","TSB_lo","TSB_hi",
                         "SSB","SSB_lo","SSB_hi",
                         "Removals","Removals_lo","Removals_hi"))

x2 <- div(summary.taf, "Rec|TSB|SSB|Removals", grep=TRUE)

x3 <- div(summary.taf, "Year|Fbar", grep=TRUE, invert=TRUE)

# Less reliable in scripts if columns have been added/deleted/reordered:

x4 <- div(summary.taf, 2:13)

}
\seealso{
\code{\link{transform}} can also be used to recalculate column values, using
a more general and verbose syntax.

\code{\link{grep}} is the underlying function used to match column names if
\code{grep} is \code{TRUE}.

\code{\link{rnd}} is a similar function that rounds columns.

\code{\link{TAF-package}} gives an overview of the package.
}
