% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{which_frm_cols}
\alias{which_frm_cols}
\title{Determine input columns to use}
\usage{
which_frm_cols(df, frm, frm_cols = NULL, verbose = TRUE)
}
\arguments{
\item{df}{Dataframe containing TCR gene names.}

\item{frm}{A string, the input format of TCR data. Must be one of
\code{"tenx"}, \code{"adaptive"}, \code{"adaptivev2"}, or \code{"imgt"}.}

\item{frm_cols}{A character vector, the custom column names to use.}

\item{verbose}{A boolean, whether to show messages. Optional; defaults to \code{TRUE}}
}
\value{
A character vector, column names to use.
}
\description{
\code{which_frm_cols()} determines the columns that are expected to hold gene
name information in the input file based on the input format (\code{frm}). It
returns a vector of those column names.
}
\examples{
tcr_file <- get_example_path("tenx.csv")
df <- read.csv(tcr_file)
which_frm_cols(df, "tenx")
}
\keyword{internal}
